
#ifndef CRYS_HOST_TST_RSA
#define CRYS_HOST_TST_RSA

/***************************************************************** 
*  @file CRYS_HOST_TST_RSA.h
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PRIME_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes RSA primitive encryption/decryption process test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PRIME_EncDec (DxUint8_t	*PubExponent_ptr,
									DxUint16_t	 PubExponentSize,
									DxUint8_t   *PrivExponent_ptr,
									DxUint16_t   PrivExponentSize,
									DxUint8_t	*Modulus_ptr,
									DxUint16_t	 KeySize,
									DxUint8_t    CRT_Mode,
									DxUint8_t   *P_ptr, 
									DxUint16_t	 PSize,
									DxUint8_t   *Q_ptr,
									DxUint16_t   QSize,
									DxUint8_t   *dP_ptr, 
									DxUint16_t   dPSize,
									DxUint8_t   *dQ_ptr,
									DxUint16_t   dQSize,
									DxUint8_t   *qInv_ptr,
									DxUint16_t   qInvSize,
									DxUint8_t   *DataIn_ptr,
									DxUint16_t   DataInSize,
									DxUint8_t   *ExpectedData_ptr,
									char        *FailureFunctionNameOut_ptr,
        						    DxUint32_t   FuncNameMaxSize);
        						    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PRIME_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes RSA primitive encryption/decryption process test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
**************************************************************************************/

EXPORT_C DxUint32 SEPQA_RSA_PRIME_SignVerify (DxUint8_t	*PubExponent_ptr,
										DxUint16_t	 PubExponentSize,
										DxUint8_t   *PrivExponent_ptr,
										DxUint16_t   PrivExponentSize,
										DxUint8_t	*Modulus_ptr,
										DxUint16_t	 KeySize,
										DxUint8_t    CRT_Mode,
										DxUint8_t   *P_ptr, 
										DxUint16_t	 PSize,
										DxUint8_t   *Q_ptr,
										DxUint16_t   QSize,
										DxUint8_t   *dP_ptr, 
										DxUint16_t   dPSize,
										DxUint8_t   *dQ_ptr,
										DxUint16_t   dQSize,
										DxUint8_t   *qInv_ptr,
										DxUint16_t   qInvSize,
										DxUint8_t   *Data_ptr,
										DxUint16_t   DataSize,
										DxUint8_t   *ExpectedData_ptr,
										char        *FailureFunctionNameOut_ptr,
        						   		DxUint32_t   FuncNameMaxSize);
        						    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* KeyGenType - type how to generate key (internal or build from external key)
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes RSA PKCS1v15 encrypt and decrypt according to PKCS#1 Ver1.5 test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PKCS1v15_EncDec (DxUint8_t	*PubExponent_ptr,
									   DxUint16_t	 PubExponentSize,
									   DxUint8_t   *PrivExponent_ptr,
									   DxUint16_t   PrivExponentSize,
									   DxUint8_t	*Modulus_ptr,
									   DxUint16_t	 KeySize,
									   DxUint16_t   KeyGenType,
									   DxUint8_t    CRT_Mode,
									   DxUint8_t   *P_ptr, 
									   DxUint16_t	 PSize,
									   DxUint8_t   *Q_ptr,
									   DxUint16_t   QSize,
									   DxUint8_t   *dP_ptr, 
									   DxUint16_t   dPSize,
									   DxUint8_t   *dQ_ptr,
									   DxUint16_t   dQSize,
									   DxUint8_t   *qInv_ptr,
									   DxUint16_t   qInvSize,
									   DxUint8_t   *Data_ptr,
									   DxUint16_t   DataSize,
									   char        *FailureFunctionNameOut_ptr,
									   DxUint32_t   FuncNameMaxSize);
									   
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify (
                                DxUint8_t	*PubExponent_ptr,
								DxUint16_t	 PubExponentSize,
								DxUint8_t   *PrivExponent_ptr,
								DxUint16_t   PrivExponentSize,
								DxUint8_t	*Modulus_ptr,
								DxUint16_t	 KeySize,
								DxUint8_t    CRT_Mode,
								DxUint8_t    KeyGenType,
								CRYS_RSA_HASH_OpMode_t hashMode,
								DxUint8_t   *P_ptr, 
								DxUint16_t	 PSize,
								DxUint8_t   *Q_ptr,
								DxUint16_t   QSize,
								DxUint8_t   *dP_ptr, 
								DxUint16_t   dPSize,
								DxUint8_t   *dQ_ptr,
								DxUint16_t   dQSize,
								DxUint8_t   *qInv_ptr,
								DxUint16_t   qInvSize,
								DxUint8_t   *Data_ptr,
								DxUint16_t   DataSize,
								char        *FailureFunctionNameOut_ptr,
							    DxUint32_t   FuncNameMaxSize);
							    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_Integrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PKCS1v15_Integrate_SignVerify (
                                DxUint8_t	*PubExponent_ptr,
								DxUint16_t	 PubExponentSize,
								DxUint8_t   *PrivExponent_ptr,
								DxUint16_t   PrivExponentSize,
								DxUint8_t	*Modulus_ptr,
								DxUint16_t	 KeySize,
								DxUint8_t    CRT_Mode,
								DxUint8_t    KeyGenType,
								CRYS_RSA_HASH_OpMode_t hashMode,
								DxUint8_t   *P_ptr, 
								DxUint16_t	 PSize,
								DxUint8_t   *Q_ptr,
								DxUint16_t   QSize,
								DxUint8_t   *dP_ptr, 
								DxUint16_t   dPSize,
								DxUint8_t   *dQ_ptr,
								DxUint16_t   dQSize,
								DxUint8_t   *qInv_ptr,
								DxUint16_t   qInvSize,
								DxUint8_t   *Data_ptr,
								DxUint16_t   DataSize,
								char        *FailureFunctionNameOut_ptr,
							    DxUint32_t   FuncNameMaxSize);
							    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_OAEP_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_OAEP_EncDec (
                                DxUint8_t	*PubExponent_ptr,
                    			DxUint16_t	 PubExponentSize,
                    			DxUint8_t   *PrivExponent_ptr,
                    			DxUint16_t   PrivExponentSize,
                    			DxUint8_t	*Modulus_ptr,
                    			DxUint16_t	 KeySize,
                    			DxUint8_t    CRT_Mode,
                    			DxUint8_t    KeyGenType,
                    			CRYS_RSA_HASH_OpMode_t hashMode,
                    			DxUint8_t   *P_ptr, 
                    			DxUint16_t	 PSize,
                    			DxUint8_t   *Q_ptr,
                    			DxUint16_t   QSize,
                    			DxUint8_t   *dP_ptr, 
                    			DxUint16_t   dPSize,
                    			DxUint8_t   *dQ_ptr,
                    			DxUint16_t   dQSize,
                    			DxUint8_t   *qInv_ptr,
                    			DxUint16_t   qInvSize,
                    			DxUint8_t   *Data_ptr,
                    			DxUint16_t   DataSize,
                    			char        *FailureFunctionNameOut_ptr,
							    DxUint32_t   FuncNameMaxSize);
							    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_NonIntegrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes test for RSA PSS PKCS#1v2.1 non integrated sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PSS_NonIntegrate_SignVerify (
                                  DxUint8_t	            *PubExponent_ptr,
								  DxUint16_t	         PubExponentSize,
								  DxUint8_t             *PrivExponent_ptr,
								  DxUint16_t             PrivExponentSize,
								  DxUint8_t	            *Modulus_ptr,
								  DxUint16_t	         KeySize,
								  DxUint8_t              CRT_Mode,
								  DxUint8_t				 KeyGenType,
								  CRYS_RSA_HASH_OpMode_t HashMode,
								  DxUint16_t		     SaltLength,
								  DxUint8_t             *P_ptr, 
								  DxUint16_t	         PSize,
								  DxUint8_t             *Q_ptr,
								  DxUint16_t             QSize,
								  DxUint8_t             *dP_ptr, 
								  DxUint16_t             dPSize,
								  DxUint8_t             *dQ_ptr,
								  DxUint16_t             dQSize,
								  DxUint8_t             *qInv_ptr,
								  DxUint16_t             qInvSize,
								  DxUint8_t             *Data_ptr,
								  DxUint16_t             DataSize,
								  char                  *FailureFunctionNameOut_ptr,
							      DxUint32_t             FuncNameMaxSize);
							      
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_Integrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes test for RSA PSS PKCS#1v2.1 integrated sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PSS_Integrate_SignVerify (
                                  DxUint8_t	            *PubExponent_ptr,
								  DxUint16_t	         PubExponentSize,
								  DxUint8_t             *PrivExponent_ptr,
								  DxUint16_t             PrivExponentSize,
								  DxUint8_t	            *Modulus_ptr,
								  DxUint16_t	         KeySize,
								  DxUint8_t              CRT_Mode,
								  DxUint8_t				 KeyGenType,
								  CRYS_RSA_HASH_OpMode_t HashMode,
								  DxUint16_t		     SaltLength,
								  DxUint8_t             *P_ptr, 
								  DxUint16_t	         PSize,
								  DxUint8_t             *Q_ptr,
								  DxUint16_t             QSize,
								  DxUint8_t             *dP_ptr, 
								  DxUint16_t             dPSize,
								  DxUint8_t             *dQ_ptr,
								  DxUint16_t             dQSize,
								  DxUint8_t             *qInv_ptr,
								  DxUint16_t             qInvSize,
								  DxUint8_t             *Data_ptr,
								  DxUint16_t             DataSize,
								  char                  *FailureFunctionNameOut_ptr,
							      DxUint32_t             FuncNameMaxSize);
							      
							      
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify (
                                DxUint8_t	*PubExponent_ptr,
								DxUint16_t	 PubExponentSize,
								DxUint8_t   *PrivExponent_ptr,
								DxUint16_t   PrivExponentSize,
								DxUint8_t	*Modulus_ptr,
								DxUint16_t	 KeySize,
								DxUint8_t    CRT_Mode,
								DxUint8_t    KeyGenType,
								CRYS_RSA_HASH_OpMode_t hashMode,
								DxUint8_t   *P_ptr, 
								DxUint16_t	 PSize,
								DxUint8_t   *Q_ptr,
								DxUint16_t   QSize,
								DxUint8_t   *dP_ptr, 
								DxUint16_t   dPSize,
								DxUint8_t   *dQ_ptr,
								DxUint16_t   dQSize,
								DxUint8_t   *qInv_ptr,
								DxUint16_t   qInvSize,
								DxUint8_t   *Data_ptr,
								DxUint16_t   DataSize,
								char        *FailureFunctionNameOut_ptr,
							    DxUint32_t   FuncNameMaxSize);							      
							    

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_ExternalHash_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
* dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes test for RSA PSS PKCS#1v2.1 integrated sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RSA_PSS_ExternalHash_SignVerify (
                                  DxUint8_t	            *PubExponent_ptr,
								  DxUint16_t	         PubExponentSize,
								  DxUint8_t             *PrivExponent_ptr,
								  DxUint16_t             PrivExponentSize,
								  DxUint8_t	            *Modulus_ptr,
								  DxUint16_t	         KeySize,
								  DxUint8_t              CRT_Mode,
								  DxUint8_t				 KeyGenType,
								  CRYS_RSA_HASH_OpMode_t HashMode,
								  DxUint16_t		     SaltLength,
								  DxUint8_t             *P_ptr, 
								  DxUint16_t	         PSize,
								  DxUint8_t             *Q_ptr,
								  DxUint16_t             QSize,
								  DxUint8_t             *dP_ptr, 
								  DxUint16_t             dPSize,
								  DxUint8_t             *dQ_ptr,
								  DxUint16_t             dQSize,
								  DxUint8_t             *qInv_ptr,
								  DxUint16_t             qInvSize,
								  DxUint8_t             *DataIn_ptr,
								  DxUint16_t             DataInSize,
								  char                  *FailureFunctionNameOut_ptr,
							      DxUint32_t             FuncNameMaxSize);							    


/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_Get_PrivAndPubKey         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
* dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes test for RSA PSS PKCS#1v2.1 integrated sign & Verify
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/    							    
									   
EXPORT_C DxUint32  SEPQA_RSA_Get_PrivAndPubKey (DxUint8_t	*PubExponent_ptr,
										DxUint16_t	 PubExponentSize,
										DxUint8_t   *PrivExponent_ptr,
										DxUint16_t   PrivExponentSize,
										DxUint8_t	*Modulus_ptr,
										DxUint16_t	 KeySize,
										DxUint8_t    CRT_Mode,
										DxUint8_t   *P_ptr, 
										DxUint16_t	 PSize,
										DxUint8_t   *Q_ptr,
										DxUint16_t   QSize,
										DxUint8_t   *dP_ptr, 
										DxUint16_t   dPSize,
										DxUint8_t   *dQ_ptr,
										DxUint16_t   dQSize,
										DxUint8_t   *qInv_ptr,
										DxUint16_t   qInvSize,
										char        *FailureFunctionNameOut,
										DxUint32_t   FuncNameMaxSize);  						    
        								   
        								   
									  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_RSA */
